#include <iostream.h>

//ein struct ist eine Klasse mit oeffentlichen methoden
struct node {
  int wert;
  node* next;
 
  node (int = 0, node* = NULL);
  ~node();
};

node::node(int n_wert, node* n_next)
{
  wert = n_wert; next = n_next;
}

node::~node()
{ 
  if (next != NULL) 
    { delete next; }
}

class Zirkulaere_Liste {
public:
  node* start;
  Zirkulaere_Liste();
  ~Zirkulaere_Liste();

  node* empty();
  bool isempty();
  
  void insert_first (int neue_wert);
  void insert_last (int neue_wert);
                                                  
  void delete_node (int del_wert);
  void invert();                                  
  int suchen (int gesuchter_wert);  //gibt die Position des gesuchten Elements zurueck
  void ausgeben();
};

Zirkulaere_Liste::Zirkulaere_Liste() { 
	start = empty(); 
}

//Dekonstruktor
Zirkulaere_Liste::~Zirkulaere_Liste()
{
  if (start != NULL)
    {
      node* p1 = start;
      
      while (p1->next != start) { 
		  p1 = p1->next; 
	  }
      p1->next = NULL;
      delete start;
    }
}

node* Zirkulaere_Liste::empty() { 
	return NULL; 
}

bool Zirkulaere_Liste::isempty() {
	return (start == NULL); 
}
//am anfang einfgen
void Zirkulaere_Liste::insert_first (int neue_wert)
{
  node* neues_elem = new node (neue_wert, start);
  
  if (!isempty())
    {
      while (start->next != neues_elem->next) { 
		  start = start->next; 
	  }
      start->next = neues_elem;
      start = neues_elem;
    }
  else
    {
      start = neues_elem;  //das 1. Element in die Liste einfuegen
      start->next = start; //und dessen next auf sich selbst zeigen lassen
    }
}
//am ende einfgen
void Zirkulaere_Liste::insert_last (int neue_wert)
{
  node* neues_elem = new node (neue_wert, start); //das neue Element
  node* p1 = start;                                 //ein Laufzeiger

  if (!isempty())
    {
      while (p1->next != start)
        { p1 = p1->next; }
      p1->next = neues_elem;
    }
  else
    {
      start = neues_elem;  
      start->next = start;
    }
}
//knoten loeschen
void Zirkulaere_Liste::delete_node (int del_wert)
{
  node* p1 = start;
  
  if (!isempty())
    {
      while ((p1->next != start) && (p1->next->wert != del_wert))
        { p1 = p1->next; }
      
      if (p1->next->wert == del_wert)
        {
          node* p2 = p1->next->next;
          if (p1->next == start) { start = p2; }
          p1->next->next = NULL; 
          if (p1->next == NULL)
            {
              delete p1->next;
              start = NULL; //wieder eine leere Liste
            }
          else { p1->next = p2; }
        }      
    }
}

//liste ausgeben
void Zirkulaere_Liste::ausgeben()
{
  node* p1 = start;

  if (!isempty())
    {
      cout << " -> " << p1->wert; 
      p1 = p1->next; 
      while (p1 != start)
        { 
          cout << " -> " << p1->wert;
          p1 = p1->next;
        }
      cout << " -> START ";
    }
  else
    {      
      cout << " -> NIL";
    }
  
}
//bestimmtes element suchen
int Zirkulaere_Liste::suchen (int gesuchter_wert)
{
  node* p1 = start;
  int zaehler = 0;
  bool gefunden = false;
  
  if (!isempty())
    {
      zaehler++;                 
      if (p1->wert != gesuchter_wert) 
        {
          p1 = p1->next;         
          while ((p1 != start) && (!gefunden))
            {
              if (p1->wert == gesuchter_wert) {
				  gefunden = true; 
			  }
              zaehler++;
              p1 = p1->next;
            }
        }
      else { 
		  gefunden = true; 
	  }  
    }
  
  if (gefunden) { 
	  return zaehler; 
  } 
           else { 
			   return 0; 
		   }      
}


main()
{
  Zirkulaere_Liste meine_Zirkulaere_Liste;           //meine zirkulaere Liste
  int    element, pos;           //wird zum einfuegen und loeschen benutzt
  char   Auswahl     = '1';      
  
  //auswahlmenue
  do
    { 
      cout << "\n1. Element an Listenanfang einfgen";
      cout << "\n2. Element an Listenende einfgen";
      cout << "\n4. Element aus Liste lschen";
      cout << "\n5. Position eines Elementes ermitteln";
      cout << "\nq  Programm beenden";
      cout << "\n\nWahl:";
      cin >> Auswahl;         
      
      switch (Auswahl)        
        {
          case '1': {
                      cout << "\nElementwert:"; 
                      cin >> element;          
                      meine_Zirkulaere_Liste.insert_first (element);
                      break;                   
                    }                          
          case '2': {
                      cout << "\nElementwert:";
                      cin >> element;           
                      meine_Zirkulaere_Liste.insert_last (element);
                      break;                   
                    }                                                    
          case '4': {
                      cout << "\nzu lschender Wert:";
                      cin >> element;
                      meine_Zirkulaere_Liste.delete_node (element);
                      break;
                    }
          case '5': {
                      cout << "\nElementwert:"; 
                      cin >> element;           
                      pos = meine_Zirkulaere_Liste.suchen (element);
                      cout << "\nDie Position der " << element << " ist " << pos << '.';
                      break;
                    }
        };
      cout << "\nInhalt der Liste\n"; //zum Ende der do-Schleife
      meine_Zirkulaere_Liste.ausgeben();  //wird die aktuelle Liste immer ausgegeben
      cout << '\n';
    }
  while (Auswahl != 'q');
} 